package com.bxm.localnews.merchant.common.event;

import com.bxm.localnews.common.constant.InviteTypeEnum;
import com.bxm.localnews.merchant.common.enums.UserActionEnum;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * 用户发起分享
 *
 * @author liujia
 * @date 2020-07-16 19:30
 **/
@EqualsAndHashCode(callSuper = true)
@Data(staticConstructor = "of")
@Accessors(chain = true)
public class ShareActionEvent extends UserActionEvent {
    private final UserActionEnum action = UserActionEnum.SHARE;

    /**
     * 分享的目标内容
     */
    private Long targetId;

    /**
     * 分享类型 : 主要是新闻和帖子
     */
    private InviteTypeEnum inviteTypeEnum;

}