/*
 * Copyright 2017 bianxianmao.com All right reserved. This software is the confidential and proprietary information of
 * bianxianmao.com ("Confidential Information"). You shall not disclose such Confidential Information and shall use it
 * only in accordance with the terms of the license agreement you entered into with bianxianmao.com.
 */
package com.bxm.localnews.merchant.common.properties;

import lombok.Data;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.stereotype.Component;

import java.math.BigDecimal;

/**
 * @author jieliGG
 * @date 2020/8/25 19:41
 * 商家的相关比率配置
 **/
@ConfigurationProperties("merchant.goods.rate")
@Component
@Data
public class MerchantGoodsRateProperties {
    /**
     * 商家选择VIP折扣时，默认折扣
     * 前提是：vip_discount = 1
     * <p>TODO 商户服务根本没使用此字段计算折扣 --> vipRebate 为vip折扣<p/>
     */
    @Deprecated
    private BigDecimal vipRate = BigDecimal.ZERO;

    /**
     * 分享人是VIP的分成
     */
    private BigDecimal vipUserRate = BigDecimal.ZERO;

    /**
     * 分享人不是VIP的分成
     */
    private BigDecimal userRate = BigDecimal.ZERO;

    /**
     * 分享人是vip时，师傅的比率
     */
    private BigDecimal vipUserInviteRate = BigDecimal.ZERO;

    /**
     * 分享人不是vip时，师傅的比率
     */
    private BigDecimal userInviteRate = BigDecimal.ZERO;

    /**
     * 分享人是vip时，二级师傅的比率
     */
    private BigDecimal vipUserTwoInviteRate = BigDecimal.ZERO;

    /**
     * 分享人不是vip时，师傅的比率
     */
    private BigDecimal userTwoInviteRate = BigDecimal.ZERO;

    /**
     * vip 折扣
     */
    private BigDecimal vipRebate = new BigDecimal("0.95");

    /**
     * 立赚比例
     */
    private BigDecimal profitRebate = new BigDecimal("0.8");

    /**
     * 团队分佣比例
     */
    private BigDecimal teamCommissionRebate = new BigDecimal("0.2");

    /**
     * 是大达人
     */
    private BigDecimal bigTalentRebate = new BigDecimal("0.4");

    /**
     * 中达人
     */
    private BigDecimal midTalentRebate = new BigDecimal("0.3");
    /**
     * 小达人
     */
    private BigDecimal smallTalentRebate = new BigDecimal("0.3");

}
