/*
 * Copyright 2017 bianxianmao.com All right reserved. This software is the confidential and proprietary information of
 * bianxianmao.com ("Confidential Information"). You shall not disclose such Confidential Information and shall use it
 * only in accordance with the terms of the license agreement you entered into with bianxianmao.com.
 */
package com.bxm.localnews.merchant.common.properties;

import lombok.Data;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.stereotype.Repository;

import java.math.BigDecimal;

/**
 * @author jieliGG
 * @date 2020/7/19 11:41
 **/
@ConfigurationProperties("user.promotion")
@Repository
@Data
public class MerchantProAccountProperties {
    /**
     * 推广金最大金额限制
     */
    private BigDecimal maxLimit = new BigDecimal("5000.0");

    /**
     * 师傅的推广金奖励
     */
    private BigDecimal masterMoney = new BigDecimal("20.0");

    /**
     * 二级师傅的推广奖励
     */
    private BigDecimal masterTwoMoney = new BigDecimal("10.0");

    /**
     * 资质认证成功奖励金额
     */
    private BigDecimal qualifyAuth = new BigDecimal("100.0");
}
