/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.merchant.common.enums;

import com.bxm.localnews.merchant.common.enums.GroupOrderStates;
import java.util.Arrays;

public enum GroupOrderSubStates {
    DISABLE_BY_TIME_OUT_CANCEL(1, GroupOrderStates.DISABLE),
    DISABLE_BY_MANUAL_CANCEL(2, GroupOrderStates.DISABLE),
    DISABLE_BY_MANUAL_REFUND(3, GroupOrderStates.DISABLE),
    DISABLE_BY_AUTO_REFUND(4, GroupOrderStates.DISABLE),
    PAY_SUCCESS_BY_REFUND_REFUSE(1, GroupOrderStates.PAY_SUCCESS);

    private int status;
    private GroupOrderStates parent;

    private GroupOrderSubStates(int status, GroupOrderStates parent) {
        this.status = status;
        this.parent = parent;
    }

    public static GroupOrderSubStates getByStatus(int status) {
        return Arrays.stream(GroupOrderSubStates.values()).filter(p -> p.getStatus() == status).findAny().orElse(DISABLE_BY_MANUAL_REFUND);
    }

    public int getStatus() {
        return this.status;
    }

    public GroupOrderStates getParent() {
        return this.parent;
    }
}

