/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.merchant.common.service;

import com.bxm.newidea.component.redis.KeyGenerator;
import com.bxm.newidea.component.redis.RedisStringAdapter;
import com.bxm.newidea.component.tools.RandomUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class VerificationCodeService {
    private static final Logger log = LoggerFactory.getLogger(VerificationCodeService.class);
    private final RedisStringAdapter redisStringAdapter;

    public VerificationCodeService(RedisStringAdapter redisStringAdapter) {
        this.redisStringAdapter = redisStringAdapter;
    }

    public Long gen(KeyGenerator key, Long startNum) {
        int bucketIndex = RandomUtils.nextInt((int)10, (int)99);
        KeyGenerator bucketKey = key.copy().appendKey((Object)bucketIndex);
        if (!this.redisStringAdapter.hasKey(bucketKey).booleanValue()) {
            int randomSeed = (int)(startNum / 100L);
            long initValue = (long)bucketIndex * startNum + (long)RandomUtils.nextInt((int)randomSeed, (int)(randomSeed * 10 - 1));
            this.redisStringAdapter.incrementWithDefault(bucketKey, initValue, 1);
            return initValue;
        }
        Long codeValue = this.redisStringAdapter.increment(bucketKey);
        if (codeValue >= (long)(bucketIndex + 1) * startNum) {
            log.warn("\u89e6\u53d1\u8d8a\u754c\uff1a{}\uff0c\u751f\u6210\u7801\uff1a{}", (Object)bucketIndex, (Object)codeValue);
            return this.gen(key, startNum);
        }
        return codeValue;
    }
}

