package com.bxm.localnews.merchant.domain.coupon;

import com.bxm.localnews.merchant.dto.coupon.ManageCouponItemDTO;
import com.bxm.localnews.merchant.dto.coupon.MerchantCouponOverviewDTO;
import com.bxm.localnews.merchant.entity.coupon.MerchantCouponInfoEntity;
import com.bxm.localnews.merchant.param.coupon.ManageCouponQueryParam;
import com.bxm.localnews.merchant.param.coupon.MerchantCouponStatusPageParam;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;

import java.util.Date;
import java.util.List;

@Mapper
public interface MerchantCouponInfoMapper {

    int insert(MerchantCouponInfoEntity record);

    /**
     * 更新不影响业务的文本信息
     *
     * @param record 优惠券信息
     * @return 更新结果
     */
    int updateTextInfo(MerchantCouponInfoEntity record);

    MerchantCouponInfoEntity selectByPrimaryKey(Long id);

    /**
     * 获取商户当前处于可用状态的优惠券信息
     *
     * @param merchantId 商户ID
     * @param status     可用状态
     * @return 优惠券列表
     */
    List<MerchantCouponInfoEntity> getMerchantUsableCoupon(@Param("merchantId") Long merchantId, @Param("status") Integer status);

    /**
     * 分页查询商家优惠券
     *
     * @param param 查询参数
     * @return 分页结果
     */
    List<MerchantCouponOverviewDTO> queryByPage(MerchantCouponStatusPageParam param);

    /**
     * 更新优惠券状态
     *
     * @param couponId 优惠券ID
     * @param status   优惠券状态
     * @return 更新影响行数
     */
    int updateStatus(@Param("couponId") Long couponId, @Param("status") Integer status);

    /**
     * 分页查询优惠券信息，在运营后台显示使用
     *
     * @param param 分页查询参数
     * @return 查询结果
     */
    List<ManageCouponItemDTO> queryCouponByPage(ManageCouponQueryParam param);

    /**
     * 获取商家所有可领取的优惠券列表【优惠券类型为商家类型】
     *
     * @param merchantId 商户id
     * @return 可领取的优惠券列表
     */
    List<MerchantCouponInfoEntity> getCouponListByMerchantId(@Param("merchantId") Long merchantId);

    /**
     * 获取商家优惠券状态异常
     *
     * @param currDate 当前时间
     * @param status   需要查询的状态
     * @return 可领取的优惠券列表
     */
    List<MerchantCouponInfoEntity> getCouponStatusErrorList(@Param("status") Integer status, @Param("currDate") Date currDate);

    /**
     * 更新商户异常状态优惠券 可用-->已过期
     *
     * @param resultStatus 要变更的状态
     *                     * @param currStatus   当前的态
     *                     * @param currDate     当前时间
     */
    void updateCouponUsableStatusToExpire(@Param("currStatus") Integer currStatus, @Param("resultStatus") Integer resultStatus,
                                          @Param("currDate") Date currDate);
}