package com.bxm.localnews.merchant.domain.coupon;

import com.bxm.localnews.merchant.dto.coupon.UserCouponDetailDTO;
import com.bxm.localnews.merchant.dto.coupon.UserCouponReminderDTO;
import com.bxm.localnews.merchant.dto.coupon.UserRecommendCouponDetailDTO;
import com.bxm.localnews.merchant.entity.coupon.MerchantCouponReceiveRecordEntity;
import com.bxm.localnews.merchant.param.coupon.UserCouponStatusPageParam;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;

import java.util.Date;
import java.util.List;

@Mapper
public interface MerchantCouponReceiveRecordMapper {

    int insert(MerchantCouponReceiveRecordEntity record);

    /**
     * 更新优惠券的状态，该方法会强制更新优惠券状态，请谨慎调用
     *
     * @param userCouponId 优惠券ID
     * @param status       优惠券状态
     * @return 更新结果
     */
    int updateStatus(@Param("userCouponId") Long userCouponId, @Param("status") Integer status);

    /**
     * 根据用户优惠券ID更新扩展字段，包括：
     * 核销时间
     * 归属订单
     * 归属订单标题
     *
     * @param entity 优惠券详情信息
     * @return 更新结果
     */
    int updateExtendInfo(MerchantCouponReceiveRecordEntity entity);

    /**
     * 批量更新优惠券的状态
     *
     * @param couponId      优惠券ID
     * @param targetStatus  更新目标状态
     * @param currentStatus 优惠券当前状态
     * @param batchId       处理批次ID，方便后续异步处理时检索数据
     * @return 更新行数
     */
    int batchUpdateStatus(@Param("couponId") Long couponId,
                          @Param("targetStatus") Integer targetStatus,
                          @Param("currentStatus") Integer currentStatus,
                          @Param("batchId") Long batchId);

    /**
     * 根据用户优惠券ID获取领取详情
     *
     * @param id 优惠券ID
     * @return 领取详情
     */
    MerchantCouponReceiveRecordEntity selectByPrimaryKey(Long id);

    /**
     * 根据核销码获取优惠券信息
     *
     * @param code 优惠券的核销码
     * @return 优惠券信息
     */
    MerchantCouponReceiveRecordEntity selectByCode(String code);

    /**
     * 获取用户持有的可用的优惠券
     *
     * @param userId       用户ID
     * @param couponId     优惠券ID
     * @param usableStatus 可用状态
     * @return 可用优惠券列表
     */
    List<MerchantCouponReceiveRecordEntity> getUserUsableCoupon(@Param("userId") Long userId,
                                                                @Param("couponId") Long couponId,
                                                                @Param("usableStatus") Integer usableStatus);

    /**
     * 获取用户的可用的某种优惠券
     *
     * @param userId       用户ID
     * @param merchantId   优惠券所属商家ID
     * @param type         优惠券类型
     * @param usableStatus 查询的优惠券状态
     * @return 可用的优惠券列表
     */
    List<UserRecommendCouponDetailDTO> getUserUsableCouponWithType(@Param("userId") Long userId,
                                                                   @Param("merchantId") Long merchantId,
                                                                   @Param("type") Integer type,
                                                                   @Param("usableStatus") Integer usableStatus);

    /**
     * 分页获取用户的优惠券
     *
     * @param param 查询参数
     * @return 用户持有的优惠券信息
     */
    List<UserCouponDetailDTO> getUserCouponByPage(UserCouponStatusPageParam param);

    /**
     * 获取即将过期的用户优惠券统计信息，用于进行相关的提示
     *
     * @param start  起始查询位置
     * @param limit  每页查询数量
     * @param status 优惠券当前所属状态
     * @param days   距离今日的天数（0：当前，1：前一天）
     * @return 用户ID与对应的统计数据
     */
    List<UserCouponReminderDTO> getReminderUserCoupon(@Param("start") Integer start,
                                                      @Param("limit") Integer limit,
                                                      @Param("status") Integer status,
                                                      @Param("days") Integer days);

    /**
     * 更新用户异常状态优惠券 可用-->已过期
     *
     * @param resultStatus 要变更的状态
     * @param currStatus   当前的态
     * @param currDate     当前时间
     */
    void updateCouponUsableStatusToExpire(@Param("currStatus") Integer currStatus, @Param("resultStatus") Integer resultStatus,
                                          @Param("currDate") Date currDate);
}