package com.bxm.localnews.merchant.domain.coupon;

import com.bxm.localnews.merchant.entity.coupon.MerchantCouponStatisticsDateEntity;
import org.apache.ibatis.annotations.Mapper;

import java.util.List;

@Mapper
public interface MerchantCouponStatisticsDateMapper {

    int insert(MerchantCouponStatisticsDateEntity record);

    MerchantCouponStatisticsDateEntity selectByPrimaryKey(Long id);

    /**
     * 根据优惠券ID查询优惠券的使用情况
     *
     * @param couponId 优惠券ID
     * @return 优惠券的每日统计数
     */
    List<MerchantCouponStatisticsDateEntity> selectByCouponId(Long couponId);

    /**
     * 根据优惠券ID和日期更新每日的统计数据
     *
     * @param record 每日统计数据
     * @return 更新结果
     */
    int updateByPrimaryKeySelective(MerchantCouponStatisticsDateEntity record);

}