package com.bxm.localnews.merchant.domain.coupon;

import com.bxm.localnews.merchant.entity.coupon.MerchantCouponStatisticsEntity;
import org.apache.ibatis.annotations.Mapper;

@Mapper
public interface MerchantCouponStatisticsMapper {

    int insert(MerchantCouponStatisticsEntity record);

    MerchantCouponStatisticsEntity selectByPrimaryKey(Long id);

    /**
     * 根据优惠券ID获取对应的统计数据
     *
     * @param couponId 优惠券ID
     * @return 统计数据
     */
    MerchantCouponStatisticsEntity selectByCouponId(Long couponId);

    /**
     * 根据优惠券ID更新统计数据
     *
     * @param record 统计数据
     * @return 更新结果
     */
    int updateByPrimaryKeySelective(MerchantCouponStatisticsEntity record);
}