package com.bxm.localnews.merchant.domain.coupon;

import com.bxm.localnews.merchant.entity.coupon.MerchantCouponStockEntity;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;

@Mapper
public interface MerchantCouponStockMapper {

    int insert(MerchantCouponStockEntity record);

    MerchantCouponStockEntity selectByPrimaryKey(Long id);

    /**
     * 根据优惠券ID获取库存信息
     *
     * @param couponId 优惠券ID
     * @return 库存信息
     */
    MerchantCouponStockEntity selectByCouponId(Long couponId);

    /**
     * 扣除库存
     *
     * @param id      库存ID记录
     * @param version 数据记录版本
     * @return 扣除结果
     */
    int decrementQuantity(@Param("id") Long id, @Param("version") Long version);

    /**
     * 查询优惠券的剩余库存
     *
     * @param couponId 优惠券ID
     * @return 剩余库存
     */
    Integer getRemainingQuantity(Long couponId);
}