/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.merchant.controller;

import com.bxm.localnews.merchant.coupon.emnus.UserCouponEventEnum;
import com.bxm.localnews.merchant.coupon.flow.adapter.UserCouponStateMachineAdapter;
import com.bxm.localnews.merchant.coupon.service.UserCouponService;
import com.bxm.localnews.merchant.dto.coupon.CashCouponDTO;
import com.bxm.localnews.merchant.param.coupon.UserCouponOrderParam;
import com.bxm.newidea.component.vo.Message;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"11-91 [\u5185\u90e8\u63a5\u53e3] \u4f18\u60e0\u5238\u76f8\u5173\u63a5\u53e3"})
@RequestMapping(value={"facade/merchant/coupon"})
@RestController
public class CouponFacadeController {
    private static final Logger log = LoggerFactory.getLogger(CouponFacadeController.class);
    private final UserCouponService userCouponService;
    private final UserCouponStateMachineAdapter userCouponStateMachineAdapter;

    @Autowired
    public CouponFacadeController(UserCouponService userCouponService, UserCouponStateMachineAdapter userCouponStateMachineAdapter) {
        this.userCouponService = userCouponService;
        this.userCouponStateMachineAdapter = userCouponStateMachineAdapter;
    }

    @ApiOperation(value="11-91-01 \u83b7\u53d6\u53ef\u7528\u7684\u73b0\u91d1\u4f18\u60e0\u5238\u4fe1\u606f", notes="\u5982\u679c\u8fd4\u56denull\u5219\u8868\u793a\u4f18\u60e0\u5238\u4e0d\u5b58\u5728\u6216\u5df2\u4e0d\u53ef\u4f7f\u7528")
    @RequestMapping(value={"getUserCouponInfo"})
    public ResponseEntity<CashCouponDTO> getUserCouponInfo(@RequestParam(value="userCouponId") Long userCouponId) {
        return ResponseEntity.ok((Object)this.userCouponService.getUsableCashCoupon(userCouponId));
    }

    @ApiOperation(value="11-91-02 \u7528\u6237\u4e0b\u5355\u65f6\u9501\u5b9a\u4f18\u60e0\u5238", notes="\u9501\u5b9a\u4f18\u60e0\u5238\u4fe1\u606f\uff0c\u5c06\u5176\u66f4\u65b0\u4e3a\u5f85\u786e\u8ba4\u72b6\u6001")
    @PostMapping(value={"lock"})
    public ResponseEntity<Message> lockUserCoupon(@RequestBody UserCouponOrderParam param) {
        log.info("\u8c03\u7528\u3010\u7528\u6237\u4e0b\u5355\u65f6\u9501\u5b9a\u4f18\u60e0\u5238\u3011\u63a5\u53e3\uff0c\u53c2\u6570\uff1a{}", (Object)param);
        boolean accept = this.userCouponStateMachineAdapter.postEvent(param, UserCouponEventEnum.ORDER);
        return ResponseEntity.ok((Object)Message.build((boolean)accept));
    }

    @ApiOperation(value="11-91-03 \u7528\u6237\u53d6\u6d88\u8ba2\u5355\u6570\uff0c\u91ca\u653e\u4f18\u60e0\u5238", notes="\u5c06\u7528\u6237\u4f18\u60e0\u5238\u8fd8\u539f\u6062\u590d\u539f\u59cb\u72b6\u6001")
    @PostMapping(value={"release"})
    public ResponseEntity<Message> releaseUserCoupon(@RequestBody UserCouponOrderParam param) {
        boolean accept = this.userCouponStateMachineAdapter.postEvent(param, UserCouponEventEnum.CANCEL);
        return ResponseEntity.ok((Object)Message.build((boolean)accept));
    }

    @ApiOperation(value="11-91-04 \u8ba2\u5355\u4ed8\u6b3e\u6210\u529f\uff0c\u6d88\u8d39\u4f18\u60e0\u5238")
    @PostMapping(value={"consume"})
    public ResponseEntity<Message> consumeUserCoupon(@RequestBody UserCouponOrderParam param) {
        boolean accept = this.userCouponStateMachineAdapter.postEvent(param, UserCouponEventEnum.PAY);
        return ResponseEntity.ok((Object)Message.build((boolean)accept));
    }
}

