/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.merchant.controller;

import com.bxm.localnews.merchant.common.properties.MerchantGoodsRateProperties;
import com.bxm.localnews.merchant.domain.UserInviteHistoryMapper;
import com.bxm.localnews.merchant.dto.MerchantOpenVipDTO;
import com.bxm.localnews.merchant.dto.goods.GoodsInfoAndUserIdDTO;
import com.bxm.localnews.merchant.entity.UserInviteHistoryEntity;
import com.bxm.localnews.merchant.param.MerchantOrderInfoParam;
import com.bxm.localnews.merchant.service.UserInviteService;
import com.bxm.localnews.merchant.service.account.boss.BossAccountActionService;
import com.bxm.localnews.merchant.service.account.boss.handle.BossAccountContext;
import com.bxm.localnews.merchant.service.goods.GoodsService;
import com.bxm.localnews.merchant.service.order.MerchantOrderInfoService;
import com.bxm.localnews.merchant.service.promote.PromoteService;
import com.bxm.localnews.merchants.dto.MerchantUserDTO;
import com.bxm.localnews.merchants.facade.service.MerchantInfoFacadeService;
import com.bxm.localnews.merchants.facade.service.MerchantRedisRefreshFacade;
import com.bxm.localnews.merchants.vo.MerchantInfoSimpleVO;
import com.bxm.newidea.component.vo.Message;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"11-90 [\u5185\u90e8\u63a5\u53e3]\u7528\u6237\u4fe1\u606f\u76f8\u5173\u63a5\u53e3"})
@RequestMapping(value={"facade/merchant"})
@RestController
public class MerchantFacadeController {
    private static final Logger log = LoggerFactory.getLogger(MerchantFacadeController.class);
    private final UserInviteService userInviteService;
    private final MerchantInfoFacadeService merchantInfoService;
    private final UserInviteHistoryMapper userInviteHistoryMapper;
    private final MerchantRedisRefreshFacade merchantRedisRefresh;
    private final MerchantGoodsRateProperties merchantGoodsRateProperties;
    private BossAccountActionService bossAccountActionService;
    private final GoodsService goodsService;
    private final MerchantOrderInfoService merchantOrderInfoService;
    private final PromoteService promoteService;

    @Autowired
    public MerchantFacadeController(UserInviteService userInviteService, MerchantInfoFacadeService merchantInfoService, UserInviteHistoryMapper userInviteHistoryMapper, MerchantRedisRefreshFacade merchantRedisRefresh, MerchantGoodsRateProperties merchantGoodsRateProperties, BossAccountActionService bossAccountActionService, GoodsService goodsService, MerchantOrderInfoService merchantOrderInfoService, PromoteService promoteService) {
        this.userInviteService = userInviteService;
        this.merchantInfoService = merchantInfoService;
        this.userInviteHistoryMapper = userInviteHistoryMapper;
        this.merchantRedisRefresh = merchantRedisRefresh;
        this.merchantGoodsRateProperties = merchantGoodsRateProperties;
        this.bossAccountActionService = bossAccountActionService;
        this.goodsService = goodsService;
        this.merchantOrderInfoService = merchantOrderInfoService;
        this.promoteService = promoteService;
    }

    @ApiOperation(value="11-90-02 \u65b0\u589e\u5546\u6237\u6536\u5f92\u4fe1\u606f", notes="\u65b0\u589e\u5546\u6237\u6536\u5f92\u4fe1\u606f")
    @PostMapping(value={"/insertMerchantInvite"})
    public ResponseEntity<Boolean> insertMerchantInvite(@RequestBody UserInviteHistoryEntity userInviteHistoryEntity) {
        return ResponseEntity.ok((Object)this.userInviteService.insert(userInviteHistoryEntity));
    }

    @ApiOperation(value="11-90-03 \u63d0\u4f9b\u7ed9\u7ba1\u7406\u540e\u53f0\u6ce8\u9500\u8d26\u53f7\u4f7f\u7528", notes="\u5220\u9664\u5546\u5bb6\u4fe1\u606f")
    @GetMapping(value={"/deleteMerchantInfo"})
    public ResponseEntity<Boolean> deleteMerchantInfo(@RequestParam(value="userId") Long userId) {
        return ResponseEntity.ok((Object)this.merchantInfoService.deleteMerchantInfoByUid(userId));
    }

    @ApiOperation(value="11-90-04 \u66f4\u65b0\u7528\u6237\u6536\u5f92\u7684VIP\u72b6\u6001", notes="\u5f53\u6fc0\u6d3bVIP\u65f6\uff0c\u9700\u8981\u53bb\u66f4\u65b0VIP\u72b6\u6001")
    @GetMapping(value={"/updateInvitedUserIdVip"})
    public ResponseEntity<Boolean> updateInvitedUserIdVip(@RequestParam(value="userId") Long userId, @RequestParam(value="activeType") String activeType) {
        return ResponseEntity.ok((Object)(this.userInviteHistoryMapper.updateInvitedUserIdVip(userId, activeType) > 0 ? 1 : 0));
    }

    @ApiOperation(value="11-90-05 \u83b7\u53d6\u7528\u6237\u7684\u5546\u6237\u72b6\u6001", notes="\u5224\u65ad\u7528\u6237\u662f\u5426\u5546\u6237\uff0c\u5982\u679c\u662f\u5546\u6237\u5219\u8fd4\u56de\u5546\u6237\u76f8\u5173\u4fe1\u606f")
    @GetMapping(value={"userMerchant"})
    public ResponseEntity<MerchantUserDTO> userMerchant(@RequestParam(value="userId") Long userId) {
        return ResponseEntity.ok((Object)this.merchantRedisRefresh.getMerchantUserCache(userId));
    }

    @ApiOperation(value="11-90-05 \u83b7\u53d6\u5546\u5bb6\u5546\u54c1\u6bd4\u7387")
    @GetMapping(value={"/getMerchantGoodsRateProperties"})
    public ResponseEntity<MerchantGoodsRateProperties> getMerchantRateProperties() {
        return ResponseEntity.ok((Object)this.merchantGoodsRateProperties);
    }

    @ApiOperation(value="11-90-06 \u5546\u5bb6\u8d26\u6237\u64cd\u4f5c")
    @PostMapping(value={"operatorMerchantAccount"})
    public ResponseEntity<Boolean> operatorMerchantAccount(@RequestBody BossAccountContext accountContext) {
        this.bossAccountActionService.bossAccountActionLogic(accountContext);
        return ResponseEntity.ok((Object)true);
    }

    @ApiOperation(value="11-90-07 \u83b7\u53d6\u5546\u54c1\u4fe1\u606f:\u8fd9\u4e2a\u65b9\u6cd5\u8fdc\u6bd4\u4f60\u770b\u5230\u7684\u6ce8\u91ca\u529f\u80fd\u8fd8\u8981\u591a\u54e6~~~~")
    @GetMapping(value={"/getGoodsInfoById"})
    public ResponseEntity<GoodsInfoAndUserIdDTO> getMerchantGoodsById(Long goodsId) {
        return ResponseEntity.ok((Object)this.goodsService.getByGoodsId(goodsId));
    }

    @GetMapping(value={"/returnGoodsNum"})
    @ApiOperation(value="11-90-08 \u9000\u8fd8\u5546\u54c1\u6570\u91cf")
    public ResponseEntity<Boolean> returnGoodsNum(@RequestParam(value="goodsId") Long goodsId, @RequestParam(value="num") Long num) {
        return ResponseEntity.ok((Object)this.goodsService.stockGoods(goodsId, Integer.valueOf(num.intValue())));
    }

    @PostMapping(value={"/addMerchantOrder"})
    @ApiOperation(value="11-90-09 \u65b0\u589e\u5546\u5bb6\u5546\u54c1\u8ba2\u5355")
    public ResponseEntity<Boolean> addMerchantOrder(@RequestBody MerchantOrderInfoParam merchantOrderInfoParam) {
        return ResponseEntity.ok((Object)(this.merchantOrderInfoService.insertBySelect(merchantOrderInfoParam) > 0 ? 1 : 0));
    }

    @PostMapping(value={"/updateMerchantOrderByNo"})
    @ApiOperation(value="11-90-10 \u6839\u636e\u8ba2\u5355\u53f7\u4fee\u6539\u5546\u5bb6\u7684 \u8ba2\u5355\u4fe1\u606f")
    public ResponseEntity<Boolean> updateMerchantOrder(@RequestBody MerchantOrderInfoParam merchantOrderInfoParam) {
        return ResponseEntity.ok((Object)(this.merchantOrderInfoService.updateByOrderNoSelect(merchantOrderInfoParam) > 0 ? 1 : 0));
    }

    @PostMapping(value={"/openMerchantVip"})
    @ApiOperation(value="11-90-11 \u5f00\u901a\u5546\u5bb6VIP\u6743\u76ca")
    public ResponseEntity<MerchantOpenVipDTO> openMerchantVip(@RequestParam(value="merchantId") Long merchantId, @RequestParam(value="userId") Long userId) {
        return ResponseEntity.ok((Object)this.merchantOrderInfoService.openMerchantVip(merchantId, userId));
    }

    @ApiOperation(value="11-90-12 \u5546\u5bb6\u6743\u76ca\u652f\u4ed8\u6210\u529f\u56de\u8c03")
    @GetMapping(value={"/paySuccessCallback"})
    public ResponseEntity<Boolean> paySuccessCallback(@RequestParam(value="orderNo") String orderNo) {
        return ResponseEntity.ok((Object)this.merchantOrderInfoService.paySuccessCallback(orderNo));
    }

    @ApiOperation(value="11-90-13 \u6839\u636e\u5546\u54c1id\u83b7\u53d6\u5546\u6237\u7684\u7b80\u6613\u4fe1\u606f")
    @GetMapping(value={"/getMerchantInfoSimpleInfo"})
    public ResponseEntity<MerchantInfoSimpleVO> getMerchantInfoSimpleInfo(@RequestParam(value="goodsId") Long goodsId) {
        return ResponseEntity.ok((Object)this.goodsService.getSimpleMerchantInfoByGoodsId(goodsId));
    }

    @ApiOperation(value="11-90-14 \u6263\u9664\u5546\u5bb6\u8ba2\u5355\u5e93\u5b58")
    @GetMapping(value={"/subOrderNum"})
    public ResponseEntity<Boolean> subOrderNum(@RequestParam(value="goodsId") Long goodsId, @RequestParam(value="num") Integer num) {
        return ResponseEntity.ok((Object)this.goodsService.stockGoods(goodsId, num));
    }

    @ApiOperation(value="11-90-15 \u6821\u9a8c\u5546\u54c1\u662f\u5426\u53ef\u4ee5\u8d2d\u4e70")
    @GetMapping(value={"/checkGoodsStatus"})
    public ResponseEntity<Message> checkGoodsStatus(@RequestParam(value="goodsId") Long goodsId, @RequestParam(value="num") Integer num, @RequestParam(value="userId") Long userId) {
        return ResponseEntity.ok((Object)this.goodsService.checkGoodsStatus(goodsId, num, userId));
    }
}

