package com.bxm.localnews.merchant.dto;

import com.bxm.newidea.component.tools.DateUtils;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.util.Date;

@ApiModel(description = "用户实体返回包装类")
@Data
public class UserInfoDTO {

    @ApiModelProperty("id")
    private Long id;

    @ApiModelProperty("用户昵称")
    private String nickname;

    @ApiModelProperty("用户头像路径")
    private String headImg;

    @ApiModelProperty("性别 0:未知; 1:男; 2:女")
    private Byte sex;

    @ApiModelProperty("状态")
    private Byte state;

    @ApiModelProperty("微信")
    private String weixin;

    @ApiModelProperty("手机")
    private String phone;

    @ApiModelProperty("注册来源")
    private String registerChannel;

    @ApiModelProperty(value = "注册关联id")
    private Long relationId;

    @ApiModelProperty(value = "邀请人id")
    private Long inviteUserId;

    @ApiModelProperty(value = "家乡地区编码")
    private String hometownCode;

    @ApiModelProperty(value = "家乡名称")
    private String hometownName;

    @ApiModelProperty("地区码")
    private String locationCode;

    @ApiModelProperty("地区名称")
    private String locationName;

    @ApiModelProperty("职业")
    private String jobTitle;

    @JsonFormat(pattern = DateUtils.DATE_TIME_FORMAT)
    @ApiModelProperty("创建日期")
    private Date createTime;

    @ApiModelProperty(value = "粉丝数量")
    private Integer fanNum;
}
