package com.bxm.localnews.merchant.facade;

import com.bxm.localnews.common.param.PointReportParam;
import com.bxm.localnews.merchant.facade.fallback.BizLogFallbackFactory;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

/**
 * 业务日志记录服务接口
 */
@FeignClient(value = "localnews", fallbackFactory = BizLogFallbackFactory.class, primary = false )
public interface BizLogFeignService {

    @ApiOperation(value = "1-100-11 通用日志埋点", notes = "参数为对应埋点需要的参数，包括事件值等.后续再有埋点需求，使用通用埋点， 不进行单独定义。埋点具体需要的参数，由调用服务的Integration进行封装")
    @PostMapping("/facade/biz/log/point")
    void point(@RequestBody PointReportParam param);
}
