package com.bxm.localnews.merchant.facade;

import com.bxm.localnews.merchant.facade.fallback.ImFallbackFactory;
import com.bxm.localnews.merchant.param.BatchMessageParam;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

/**
 * @author wzy
 * @version 1.0
 * @date 2020/10/29 8:51 下午
 */
@Api(tags = "4-95 [内部]帖子接口")
@FeignClient(value = "localnews-im", fallbackFactory = ImFallbackFactory.class, primary = false)
public interface ImFeignService {
    @ApiOperation(value = "7-99-12 批量发送消息")
    @PostMapping("facade/im/batch/message")
    ResponseEntity<Boolean> batchMessage(@RequestBody BatchMessageParam param);
}