/*
 * Copyright 2017 bianxianmao.com All right reserved. This software is the confidential and proprietary information of
 * bianxianmao.com ("Confidential Information"). You shall not disclose such Confidential Information and shall use it
 * only in accordance with the terms of the license agreement you entered into with bianxianmao.com.
 */
package com.bxm.localnews.merchant.facade;

import com.bxm.localnews.merchant.entity.OrderInfoDTO;
import com.bxm.localnews.merchant.facade.fallback.MarketFallbackFactory;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestParam;

/**
 * @author jieliGG
 * @date 2020/9/2 23:15
 **/
@FeignClient(value = "localnews-market", fallbackFactory = MarketFallbackFactory.class, primary = false)
public interface MarketFeignService {

    @GetMapping("/facade/order/getDetailByOrderNo")
    ResponseEntity<OrderInfoDTO> getDetailByOrderNo(@RequestParam("orderNo") String orderNo);


    @ApiOperation("10-61-02 根据订单号同意/拒绝退单")
    @GetMapping("/facade/order/operatorOrder")
    ResponseEntity<Boolean> operatorOrder(@RequestParam("orderNo") String orderNo, @RequestParam("result") Integer result);

    @ApiOperation("10-61-03 根据核销码核销订单")
    @GetMapping("/facade/order/verificationOrder")
    ResponseEntity<Integer> verificationOrder(@RequestParam("orderNo") String orderNo, @RequestParam("merchantId") Long merchantId);


    @ApiOperation("10-61-04 根据订单id获取订单信息")
    @GetMapping("/facade/order/getSomeInfoById")
    ResponseEntity<OrderInfoDTO> getSomeInfoById(@RequestParam("orderId") Long orderId);


}
