package com.bxm.localnews.merchant.facade;

import com.bxm.localnews.merchant.dto.NewsBriefInfoDto;
import com.bxm.localnews.merchant.facade.fallback.NewsFallbackFactory;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;

/**
 * 新闻服务 - 获取新闻相关的接口
 *
 * @author copy liujia by jieli.xu
 * @date 2020/05/12 11:22
 */
@RequestMapping("facade/news")
@FeignClient(value = "localnews-news", fallbackFactory = NewsFallbackFactory.class, primary = false)
public interface NewsFacadeService {


    /**
     * 获取新闻简略信息
     *
     * @param newsId   新闻ID
     * @param areaCode 访问请求来源用户所属区域编码
     * @param userId   访问接口的用户ID
     * @return
     */
    @GetMapping("briefInfo")
    ResponseEntity<NewsBriefInfoDto> getBriefInfo(@RequestParam("newsId") Long newsId,
                                                  @RequestParam(value = "areaCode", required = false) String areaCode,
                                                  @RequestParam(value = "userId", required = false) Long userId);
}
