package com.bxm.localnews.merchant.facade;

import com.bxm.localnews.merchant.dto.UserInfoDTO;
import com.bxm.localnews.merchant.dto.UserInviteHistoryDTO;
import com.bxm.localnews.merchant.facade.fallback.UserFallbackFactory;
import com.bxm.localnews.merchant.param.UserFollowTypeParam;
import com.bxm.localnews.user.enums.LocalNewsUserJudgeMarkerEnum;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;

import java.util.List;

/**
 * @Author: pf.w
 * @Date: 2020/7/14 10:17
 */
@FeignClient(value = "localnews-user", fallbackFactory = UserFallbackFactory.class, primary = false)
public interface UserFeignService {

    @GetMapping("/facade/user/info")
    ResponseEntity<UserInfoDTO> getUserFromCache(@RequestParam("userId") Long userId);

    @PostMapping("/facade/user/getVirtualUserList")
    ResponseEntity<List<UserInfoDTO>> getVirtualUserList(@RequestParam("num") Integer num);

    @GetMapping("/facade/user/invite/getInviteHistoryListByUid")
    ResponseEntity<List<UserInviteHistoryDTO>> getInviteHistoryListByUid(@RequestParam("userId") Long userId);

    @PostMapping("/facade/user/follow")
    ResponseEntity<Boolean> follow(@RequestBody UserFollowTypeParam param);

    @GetMapping("facade/user/isVip")
    ResponseEntity<Boolean> checkUserIsVip(@RequestParam("userId") Long userId);

    @ApiOperation(value = "9-88-01 判断用户是否关注了对方")
    @GetMapping("facade/user/isFollow")
    ResponseEntity<Boolean> isFollow(@RequestParam("fromUserId") Long fromUserId, @RequestParam("toUserId") Long toUserId);

    /**
     * 9-93-29 更新标志位
     */
    @GetMapping("facade/user/updateUserJudgeMarker")
    ResponseEntity<Boolean> updateUserJudgeMarker(@RequestParam("userId") Long userId,
                                                  @RequestParam("judgeMarker") LocalNewsUserJudgeMarkerEnum judgeMarker,
                                                  @RequestParam("add") Boolean add);
}
