package com.bxm.localnews.merchant.facade.fallback;

import com.alibaba.fastjson.JSON;
import com.bxm.localnews.merchant.facade.ImFeignService;
import com.bxm.localnews.merchant.param.BatchMessageParam;
import feign.hystrix.FallbackFactory;
import lombok.extern.slf4j.Slf4j;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Component;

/**
 * @author wzy
 * @version 1.0
 * @date 2020/10/29 8:55 下午
 */
@Slf4j
@Component
public class ImFallbackFactory implements FallbackFactory<ImFeignService> {
    @Override
    public ImFeignService create(Throwable e) {
        return new ImFeignService() {
            @Override
            public ResponseEntity<Boolean> batchMessage(BatchMessageParam param) {
                log.error("batchMessage() params: {} ", JSON.toJSONString(param), e);
                return ResponseEntity.badRequest().build();
            }
        };
    }
}