package com.bxm.localnews.merchant.facade.fallback;

import com.bxm.localnews.merchant.entity.OrderInfoDTO;
import com.bxm.localnews.merchant.facade.MarketFeignService;
import feign.hystrix.FallbackFactory;
import lombok.extern.slf4j.Slf4j;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Component;
import org.springframework.web.bind.annotation.RequestParam;

@Component
@Slf4j
public class MarketFallbackFactory implements FallbackFactory<MarketFeignService> {
    @Override
    public MarketFeignService create(Throwable throwable) {
        return new MarketFeignService() {
            @Override
            public ResponseEntity<OrderInfoDTO> getDetailByOrderNo(String orderNo) {
                return ResponseEntity.badRequest().build();
            }

            @Override
            public ResponseEntity<Boolean> operatorOrder(String orderNo, Integer result) {
                return ResponseEntity.badRequest().build();
            }

            @Override
            public ResponseEntity<Integer> verificationOrder(String orderNo, Long merchantId) {
                return ResponseEntity.badRequest().build();
            }

            @Override
            public ResponseEntity<OrderInfoDTO> getSomeInfoById(Long orderId) {
                return ResponseEntity.badRequest().build();
            }
        };
    }
}
