package com.bxm.localnews.merchant.facade.fallback;

import com.bxm.localnews.merchant.dto.UserInfoDTO;
import com.bxm.localnews.merchant.dto.UserInviteHistoryDTO;
import com.bxm.localnews.merchant.facade.UserFeignService;
import com.bxm.localnews.merchant.param.UserFollowTypeParam;
import com.bxm.localnews.user.enums.LocalNewsUserJudgeMarkerEnum;
import feign.hystrix.FallbackFactory;
import lombok.extern.slf4j.Slf4j;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Component;

import java.util.ArrayList;
import java.util.List;

/**
 * @Author: pf.w
 * @Date: 2020/7/14 10:18
 */
@Component
@Slf4j
public class UserFallbackFactory implements FallbackFactory<UserFeignService> {
    @Override
    public UserFeignService create(Throwable throwable) {
        return new UserFeignService() {
            @Override
            public ResponseEntity<UserInfoDTO> getUserFromCache(Long userId) {
                log.error(throwable.getMessage(), throwable);

                UserInfoDTO userInfoDTO = new UserInfoDTO();
                userInfoDTO.setNickname("未知用户");
                return ResponseEntity.ok(userInfoDTO);
            }

            @Override
            public ResponseEntity<List<UserInfoDTO>> getVirtualUserList(Integer num) {
                log.error(throwable.getMessage(), throwable);

                List<UserInfoDTO> list = new ArrayList<>();
                return ResponseEntity.ok(list);
            }


            @Override
            public ResponseEntity<List<UserInviteHistoryDTO>> getInviteHistoryListByUid(Long userId) {
                log.error(throwable.getMessage(), throwable);

                List<UserInviteHistoryDTO> list = new ArrayList<>();
                return ResponseEntity.ok(list);
            }

            @Override
            public ResponseEntity<Boolean> follow(UserFollowTypeParam param) {
                log.error(throwable.getMessage(), throwable);

                return ResponseEntity.ok(false);
            }

            @Override
            public ResponseEntity<Boolean> checkUserIsVip(Long userId) {
                log.error(throwable.getMessage(), throwable);

                return ResponseEntity.ok(false);
            }

            @Override
            public ResponseEntity<Boolean> isFollow(Long fromUserId, Long toUserId) {
                log.error(throwable.getMessage(), throwable);

                return ResponseEntity.ok(false);
            }

            @Override
            public ResponseEntity<Boolean> updateUserJudgeMarker(Long userId,
                                                                 LocalNewsUserJudgeMarkerEnum judgeMarker, Boolean add) {
                log.error(throwable.getMessage(), throwable);

                return ResponseEntity.ok(false);
            }
        };
    }
}
