/*
 * Copyright 2017 bianxianmao.com All right reserved. This software is the confidential and proprietary information of
 * bianxianmao.com ("Confidential Information"). You shall not disclose such Confidential Information and shall use it
 * only in accordance with the terms of the license agreement you entered into with bianxianmao.com.
 */
package com.bxm.localnews.merchant.integration;

import com.bxm.localnews.merchant.entity.OrderInfoDTO;
import com.bxm.localnews.merchant.facade.MarketFeignService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Component;
import org.springframework.web.bind.annotation.RequestParam;

/**
 * @author jieliGG
 * @date 2020/9/2 23:15
 **/
@Component
public class MarketIntegrationService {

    @Autowired
    private MarketFeignService marketFeignService;

    /***
     * 根据订单号获取详情
     * @param orderNo
     * @return
     */
    public OrderInfoDTO getDetailByOrderNo(@RequestParam("orderNo") String orderNo) {
        return marketFeignService.getDetailByOrderNo(orderNo).getBody();
    }

    /**
     * 审核退单信息
     *
     * @param orderNo ： 订单号
     * @param result  ： 0-拒绝 1-同意
     * @return
     */
    public Boolean operatorOrder(@RequestParam("orderNo") String orderNo, @RequestParam("result") Integer result) {
        return marketFeignService.operatorOrder(orderNo, result).getBody();
    }

    /**
     * 根据核销码核销订单
     *
     * @param orderNo    ： 核销码
     * @param merchantId ： 商家id
     * @return ： 核销结果 1-成功核销 2-核销码错误 3-已经核销过了
     */
    public Integer verificationOrder(String orderNo, Long merchantId) {
        return marketFeignService.verificationOrder(orderNo, merchantId).getBody();
    }


    /**
     * 根据核销码核销订单
     *
     * @param orderId : 订单id
     * @return ： 核销结果
     */
    public OrderInfoDTO getSomeInfoById(Long orderId) {
        try {
            ResponseEntity<OrderInfoDTO> orderEntity = marketFeignService.getSomeInfoById(orderId);
            if (null != orderEntity) {
                return orderEntity.getBody();
            }
        } catch (Exception e) {

        }
        return new OrderInfoDTO();
    }


}
