package com.bxm.localnews.merchant.param;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.math.BigDecimal;

/**
 * @author gonzo
 * @date 2020-09-01 17:49
 **/
@Data
@ApiModel(value = "商家提现打款参数")
public class MerchantWithdrawFacadeParam {

    @ApiModelProperty(value = "商户id", required = true)
    private Long merchantId;

    @ApiModelProperty("提现流水单号")
    private String withdrawNo;

    @ApiModelProperty("提现渠道")
    private Long payChannel;

    @ApiModelProperty("提现账号的真实姓名")
    private String realName;

    @ApiModelProperty("提现账号 支付宝账号 or 微信 oid")
    private String payAccount;

    @ApiModelProperty("提现金额")
    private BigDecimal amount;

}
