package com.bxm.localnews.merchant.dto;


import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.util.Date;

/**
 * @Author: pf.w
 * @Date: 2020/7/9 11:26
 */
@ApiModel(description = "便民服务基础信息")
@Data
public class BmBaseInfo {
    @ApiModelProperty("id")
    private Long id;

    @ApiModelProperty("商家ID")
    private Long merchantId;

    @ApiModelProperty("商家名称")
    private String merchantName;

    @ApiModelProperty("分类名称")
    private String categoryName;

    @ApiModelProperty("地区码")
    private String areaCode;

    @ApiModelProperty("便民页推荐位置")
    private Integer bmOrder;

    @ApiModelProperty("开始时间")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private Date bmStartTime;

    @ApiModelProperty("结束时间")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private Date bmEndTime;

    @ApiModelProperty("频道推荐位置")
    private Integer channelOrder;

    @ApiModelProperty("开始时间")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private Date channelStartTime;

    @ApiModelProperty("结束时间")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private Date channelEndTime;

    @ApiModelProperty("频道球区推荐位置")
    private Integer channelQuOrder;

    @ApiModelProperty("开始时间")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private Date channelQuStartTime;

    @ApiModelProperty("结束时间")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private Date channelQuEndTime;

    @ApiModelProperty("简称")
    private String shortDesc;

}
