package com.bxm.localnews.merchant.dto;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.util.Date;

@ApiModel(description = "后台查询装修基本信息出参")
@Data
public class ManageMerchantInfoDto {
    @ApiModelProperty("商家id")
    private Long id;

    @ApiModelProperty("店铺名称")
    private String merchantName;

    @ApiModelProperty("商户行业分类id")
    private Long categoryId;

    @ApiModelProperty("商家店铺简称")
    private String shortName;

    @ApiModelProperty("'联系人名称")
    private String manageName;

    @ApiModelProperty("联系电话")
    private String mobile;

    @ApiModelProperty("省编码")
    private String provinceCode;

    @ApiModelProperty("市编码")
    private String cityCode;

    @ApiModelProperty("区编码")
    private String countyCode;

    @ApiModelProperty("详细地址信息")
    private String address;

    @ApiModelProperty("开放时间 0: 全天开放 1: 指定时间开放")
    private Integer openType;

    @ApiModelProperty("营业开始时间 0000 为00:00")
    private String openTime;

    @ApiModelProperty("营业结束时间 0000 为00:00")
    private String closeTime;

    @ApiModelProperty("店铺头图的json数组字符串")
    private String headPics;

    @ApiModelProperty("logo图片地址")
    private String logo;

    @ApiModelProperty("相册图片地址的json数组集合")
    private String album;

    @ApiModelProperty("商户一句话描述")
    private String des;

    @ApiModelProperty("商家绑定的用户id")
    private Long userId;

    @ApiModelProperty("店铺详情描述")
    private String detailContent;
    //后台
    @ApiModelProperty("店铺可用状态 0未审核1审核上架2审核下架")
    private Integer isShelf;
    //后台
    @ApiModelProperty("下架原因")
    private String removalReason;
}
