/*
 * Copyright 2017 bianxianmao.com All right reserved. This software is the confidential and proprietary information of
 * bianxianmao.com ("Confidential Information"). You shall not disclose such Confidential Information and shall use it
 * only in accordance with the terms of the license agreement you entered into with bianxianmao.com.
 */
package com.bxm.localnews.merchant.dto;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.math.BigDecimal;

/**
 * @author jieliGG
 * @date 2020/8/21 9:14
 * 商家提现列表参数
 **/
@Data
public class MerchantWithdrawDTO {
    @ApiModelProperty("申请单号")
    private String orderNo;

    @ApiModelProperty("商户id")
    private Long merchantId;

    @ApiModelProperty("商户名称")
    private Long merchantName;

    @ApiModelProperty("提现渠道")
    private String payChannel;

    @ApiModelProperty("真实姓名")
    private String realName;

    @ApiModelProperty("提现账号")
    private String payAccount;

    @ApiModelProperty("本次提现金额")
    private BigDecimal amount;

    @ApiModelProperty("手续费")
    private BigDecimal fee;

    @ApiModelProperty("提现状态  1-待审核 2-支付中 3-支付成功 4-支付失败 5-延迟审核")
    private Integer state;

    @ApiModelProperty("客户端提现ip")
    private String clientIp;

    @ApiModelProperty("设备信息")
    private String equipment;

    @ApiModelProperty("已提现金额")
    private BigDecimal hasWithdraw;

    @ApiModelProperty("累计收入")
    private BigDecimal totalMoney;


}
