package com.bxm.localnews.merchant.dto;

import com.bxm.newidea.component.tools.DateUtils;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.math.BigDecimal;
import java.util.Date;

/**
 * 推广明细
 * @author : jieli.xu
 * @date 2020/7/9 17:41
 */
@Data
@ApiModel("推广明细参数")
public class PromoteDetailDTO {
    @ApiModelProperty("项目名称")
    private String title;
    @ApiModelProperty("收入/支出 金额")
    private BigDecimal money;
    @ApiModelProperty("日期")
    @JsonFormat(pattern = DateUtils.DATE_TIME_FORMAT)
    private Date date;
}
