/*
 * Copyright 2017 bianxianmao.com All right reserved. This software is the confidential and proprietary information of
 * bianxianmao.com ("Confidential Information"). You shall not disclose such Confidential Information and shall use it
 * only in accordance with the terms of the license agreement you entered into with bianxianmao.com.
 */
package com.bxm.localnews.merchant.dto;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.math.BigDecimal;

/**
 * @author : jieli.xu
 * @date 2020/7/9 17:01
 */
@ApiModel("推广金信息结果")
@Data
public class PromoteMoneyDTO {

    @ApiModelProperty("现价总金额")
    private BigDecimal totalMoney;

    @ApiModelProperty("推广金金额【已省金额】")
    private BigDecimal promoteMoney;

    @ApiModelProperty("所需金额[实际支付]=总金额-推广金金额")
    private BigDecimal money;

    @ApiModelProperty("店铺名称")
    private String merchantName;

    @ApiModelProperty("原价总金额")
    private BigDecimal originalMoney;

    @ApiModelProperty("剩余推广金")
    private BigDecimal leftPromoteMoney;

    @ApiModelProperty("商家id")
    private Long merchantId;

    @ApiModelProperty("权益id")
    private Long interestId;

    @ApiModelProperty("0-vip 1-广告")
    private Long openType = 0L;

}
