package com.bxm.localnews.merchant.dto;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Builder;
import lombok.Data;
import lombok.experimental.Tolerate;

import java.util.List;

@ApiModel(description = "话题")
@Data
@Builder
public class TopicFacadeVO {

    @Tolerate
    public TopicFacadeVO() {
    }

    @ApiModelProperty("id")
    private Long id;

    @ApiModelProperty("标题")
    private String title;

    @ApiModelProperty("描述")
    private String descp;

    @ApiModelProperty("图标")
    private String img;

    @ApiModelProperty("参与人数")
    private Long participantsNum;

    @ApiModelProperty("小程序分享路由")
    private String appletShareUrl;

    @ApiModelProperty("h5分享链接")
    private String shareUrl;

    @ApiModelProperty("引导发帖文案")
    private String leadPostContent;

    @ApiModelProperty("头条/本地圈推荐语")
    private String recommendContent;

    @ApiModelProperty("参与者代号")
    private String joinCode;

    @ApiModelProperty("参与者头像列表")
    private List<String> joinHeadImgList;

    @ApiModelProperty("内容")
    private String content;
}