package com.bxm.localnews.merchant.dto;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Builder;
import lombok.Data;
import lombok.experimental.Tolerate;

import java.math.BigDecimal;

@ApiModel(description = "用户成功邀请人信息")
@Data
@Builder
public class UserInviteDTO {

    @Tolerate
    public UserInviteDTO() {
    }

    @ApiModelProperty("被邀请人用户ID")
    private Long inviteUserId;

    @ApiModelProperty("被邀请人用户昵称")
    private String inviteNickName;

    @ApiModelProperty("被邀请人用户头像")
    private String inviteHeadImg;


    @ApiModelProperty("是否开通VIP，true表示已开通")
    private Boolean activeVip;

    @ApiModelProperty("开通类型：ACTIVE_CODE-激活码 ，WELFARE_VIP -付费开通")
    private String activeType;

    @ApiModelProperty("邀请开通的渠道对应的标题（如新闻标题）")
    private String relationTitle;

    @ApiModelProperty("推广金金额：20元")
    private BigDecimal promoteMoney;

    @ApiModelProperty("推广现金奖励：5元")
    private BigDecimal promoteCashMoney;

    @ApiModelProperty("徒弟等级 1/2 级徒弟")
    private Integer level;

}
