package com.bxm.localnews.merchant.dto.account;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.math.BigDecimal;
import java.util.Date;

/**
 * @author pf.w
 * @date 2020/8/21 9:14
 **/
@ApiModel(description = "商家收支流水返回实体")
@Data
public class BossCashDTO {

    @ApiModelProperty("交易明细id")
    private Long cashId;

    @ApiModelProperty("流水类型 CASH_PAYMENT : 收入  " +
            "| CASH_INCOME_CHARGE : 手续费  " +
            "| CASH_WITHDRAW_SUCCESS ; 提现 " +
            "| CASH_WITHDRAW_FALSE : 提现失败 " +
            "| CASH_DIVIDE ：分销佣金 " +
            "| CASH_WITHDRAW_ING ： 提现中 " +
            "| CASH_DRAWBACK ：商品退款 " +
            "| CASH_OUT_CHARGE ： 手续费退还 " +
            "| CASH_WITHDRAW_SUCCESS_CHARGE ：分销佣金退还" +
            "| PLATFORM_SUBSIDY ： 平台补贴")
    private String type;

    @ApiModelProperty("收支类型描述")
    private String cashDesc;

    @ApiModelProperty("收支金额  可为负数")
    private BigDecimal amount;

    @ApiModelProperty("商品名称")
    private String goodsName;

    @ApiModelProperty("时间")
    private Date createTime;

    @ApiModelProperty("提现相关即为提现业务ID | 订单相关即为订单业务ID")
    private Long relationId;
}
