/*
 * Copyright 2017 bianxianmao.com All right reserved. This software is the confidential and proprietary information of
 * bianxianmao.com ("Confidential Information"). You shall not disclose such Confidential Information and shall use it
 * only in accordance with the terms of the license agreement you entered into with bianxianmao.com.
 */
package com.bxm.localnews.merchant.dto.account;

import com.bxm.localnews.merchant.common.enums.MerchantAccountTypeEnum;
import lombok.Data;

import java.math.BigDecimal;

/**
 * @author : jieli.xu
 * @date 2020/7/15 15:49
 * 商户账号信息设置参数
 */
@Data
public class MerchantAccountInfoDTO {
    /**
     * 用户id : 必传
     */
    private Long userId;

    /**
     * 商户id ： 必传
     */
    private Long merchantId;

    /**
     * 类型
     */
    private MerchantAccountTypeEnum type;

    /**
     * 如果是金额增加，会根据具体的业务来对amount的值进行重新赋值，具体可以看实现
     * {@link com.bxm.localnews.merchant.service.account.add.AbstractAddProAccount#setAmount() }
     * 金额：正负，单位元
     * 如果有值，优先取这里的值，否则是从配置文件里面的配置的价格去获取
     */
    private BigDecimal amount;

    /**
     * 关联的业务ID
     */
    private Long relationId;

    /**
     * 关联的业务名称
     */
    private String relationTitle;

}
