package com.bxm.localnews.merchant.dto.coupon;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Builder;
import lombok.Data;
import lombok.experimental.Tolerate;

import java.math.BigDecimal;

/**
 * @author liujia
 * @date 2020-09-28 14:27
 **/
@Builder
@Data
@ApiModel(description = "现金优惠券信息")
public class CashCouponDTO {

    @Tolerate
    public CashCouponDTO() {
    }

    @ApiModelProperty("用户优惠券金额")
    private Long userCouponId;

    @ApiModelProperty("优惠券抵扣金额")
    private BigDecimal amount;

    @ApiModelProperty("现金优惠券当前状态")
    private Integer status;
}
