package com.bxm.localnews.merchant.dto.coupon;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * @author liujia
 * @date 2020-09-21 20:12
 **/
@EqualsAndHashCode(callSuper = true)
@Data
@ApiModel(description = "商户显示的核销信息")
public class MerchantCouponCheckInfoDTO extends BaseCouponInfoDTO {
    @ApiModelProperty("是否有金额使用门槛")
    private Boolean conditionAmount;

    @ApiModelProperty("使用规则")
    private String ruleRemark;

    @ApiModelProperty("核销用户昵称")
    private String nickName;

    @ApiModelProperty("核销用户是否为VIP")
    private Boolean vipFlag;

    @ApiModelProperty("核销用户的手机号码")
    private String phone;

    @ApiModelProperty("是否未到达可用时间，true表示未到达，需要进行提示")
    private Boolean tooEarly;

    @ApiModelProperty("是否已进行过核销，true表示已核销过")
    private Boolean checked;

    @ApiModelProperty("用户优惠券ID")
    private Long userCouponId;

    @ApiModelProperty("优惠券的类型，0商家优惠券（直接核销）1（现金红包）")
    private Integer type;

    @ApiModelProperty("核销码状态 0-已核销 1-未核销  2-核销码错误")
    private Integer verificationState;
}
