package com.bxm.localnews.merchant.dto.coupon;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Tolerate;

/**
 * @author liujia
 * @date 2020-09-21 20:04
 **/
@EqualsAndHashCode(callSuper = true)
@Data
@ApiModel(description = "用户优惠券核销信息")
@Builder
public class UserCouponCheckInfoDTO extends BaseCouponInfoDTO {

    @Tolerate
    public UserCouponCheckInfoDTO() {
    }

    @ApiModelProperty("优惠券ID")
    private Long couponId;

    @ApiModelProperty("优惠券核销码")
    private String code;

    @ApiModelProperty("商家地址")
    private String merchantAddress;

    @ApiModelProperty("商家电话")
    private String merchantPhone;

    @ApiModelProperty("是否有金额使用门槛")
    private Boolean conditionAmount;

    @ApiModelProperty("优惠券的类型，0商家优惠券（直接核销）1（现金红包）")
    private Integer type;
}
