package com.bxm.localnews.merchant.dto.coupon;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * @author liujia
 * @date 2020-09-21 18:45
 **/
@EqualsAndHashCode(callSuper = true)
@Data
@ApiModel(description = "优惠券信息与当前用户的可领取状态信息")
public class UserCouponInfoWithReceiveDTO extends BaseCouponInfoDTO {

    @ApiModelProperty("当前优惠券的可领取状态，1：立即领取、2：再领取、3：关注并领取、4：已领取")
    private Integer receiveStatus;

    @ApiModelProperty("当前用户的领取数量,领取数量大于0则表示用户已经领取了该优惠券")
    private Integer receiveNum;
}
