package com.bxm.localnews.merchant.dto.coupon;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * @author liujia
 * @date 2020-09-21 18:21
 **/
@EqualsAndHashCode(callSuper = true)
@Data
@ApiModel(description = "用户分享优惠券需要的相关数据")
public class UserShareCouponDTO extends BaseCouponInfoDTO {

    @ApiModelProperty("分享人ID")
    private Long userId;

    @ApiModelProperty("分享人昵称")
    private String nickName;

    @ApiModelProperty("优惠券所属商户ID")
    private Long merchantId;

    @ApiModelProperty("优惠券所属商户名称")
    private String merchantName;

    @ApiModelProperty("优惠券所属商户头图")
    private String merchantMasterPicture;

    @ApiModelProperty("优惠券的分享文案")
    private String shareTips;

    @ApiModelProperty("优惠券的使用规则")
    private String ruleRemark;

    @ApiModelProperty("是否有金额使用门槛")
    private Boolean conditionAmount;

    @ApiModelProperty("优惠券当前状态,1:可领取状态，2：未开始，3：已领完，97：已过期，98：已停用,99：已作废")
    private Integer status;

    @ApiModelProperty("用户可抵扣的优惠券ID，如果存在，则说明用户已经领取过该优惠券")
    private Long userCouponId;

    @ApiModelProperty("当前用户还是否可以领取，如果在可领取状态下，对这个字段再进行判断")
    private Boolean hasReceive;

    @ApiModelProperty("优惠券的类型，0商家优惠券（直接核销）1（现金红包）")
    private Integer type;

    @ApiModelProperty("是否需要关注（1：有，0：无）")
    private Integer conditionFollow;
}
