package com.bxm.localnews.merchant.dto.goods;

import io.swagger.annotations.ApiModelProperty;
import lombok.Builder;
import lombok.Data;
import lombok.experimental.Tolerate;

import java.util.List;

/**
 * 商品弹幕信息
 *
 * @author zhoujincheng
 * @date 2020-08-20 18:35
 */
@Data
@Builder
public class BarrageDTO {

    @Tolerate
    public BarrageDTO() {
    }

    @ApiModelProperty("顶部弹幕")
    List<BarrageTopDTO> barrageTopList;

    @ApiModelProperty("围观头像,最多展示30个")
    List<String> headImgList;

    @ApiModelProperty("围观人数")
    private Integer number;

}
