package com.bxm.localnews.merchant.dto.goods;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.math.BigDecimal;

/**
 * @author: zhoujincheng
 * @create: 2020-08-20 16:50
 */
@Data
public class QueryGoodsDTO {

    @ApiModelProperty("商品类型0单品1套餐")
    private Integer type;

    @ApiModelProperty("商品名称")
    private String name;

    @ApiModelProperty("商品轮播图")
    private String headPics;

    @ApiModelProperty("原价")
    private BigDecimal originalPrice;

    @ApiModelProperty("现价")
    private BigDecimal price;

    @ApiModelProperty("计算后的折扣")
    private BigDecimal discount;

    @ApiModelProperty("减免金额")
    private BigDecimal reducedPrice;

    @ApiModelProperty("计算后的vip折扣价格")
    private BigDecimal vipPrice;

    @ApiModelProperty("0关闭vip折扣1开启vip折扣")
    private Integer vipDiscount;

    @ApiModelProperty("使用规则")
    private String rule;

    @ApiModelProperty("店铺详情")
    private String detail;

    /**
     * 商家信息栏
     */
    @ApiModelProperty("店铺名称")
    private String merchantName;

    @ApiModelProperty("商家id")
    private Long merchantId;

    @ApiModelProperty("详细地址信息")
    private String address;

    @ApiModelProperty("微官网头图第一张")
    private String merchantPic;

    @ApiModelProperty("经度")
    private BigDecimal longitude;

    @ApiModelProperty("纬度")
    private BigDecimal latitude;


    @ApiModelProperty("库存")
    private Integer num;

    private Long goodsId;

    @ApiModelProperty("佣金比例")
    private Integer commissionRate;

    /**
     * 套餐明细
     */
    @ApiModelProperty("套餐内容")
    private String setMeal;

    /**
     * 审核状态
     */
    @ApiModelProperty("0:待审核 1:审核中 2: 资质审核通过 3: 资质审核拒绝")
    private Integer qualificationStatus;

    @ApiModelProperty("手机")
    private String phone;

    @ApiModelProperty("0下架1上架")
    private Integer shelfType;

    @ApiModelProperty("0未收藏1已收藏")
    private Integer collectionType;

    @ApiModelProperty("0不是示例商品1是示例商品")
    private Integer sampleType;

    @ApiModelProperty("立赚价格")
    private BigDecimal immediatelyPrice;

    /**
     * 页面跳转
     */
    @ApiModelProperty("0非正常商品，1正常商品")
    private Integer pageState;

    @ApiModelProperty("用户是否有当前商品的订单，0：没有订单 1：有订单")
    private Integer buyType;

}
