package com.bxm.localnews.merchant.entity;

import lombok.Data;

import java.math.BigDecimal;
import java.util.Date;

/**
 * t_merchant_account
 *
 * @author
 */
@Data
public class MerchantAccountEntity {
    private Long id;

    /**
     * 商家id
     */
    private Long merchantId;

    /**
     * 可提现金额
     */
    private BigDecimal drawableCash;

    /**
     * 总金额
     */
    private BigDecimal totalCash;

    /**
     * 冻结中金额
     */
    private BigDecimal freezeCash;

    /**
     * 已提现金额
     */
    private BigDecimal withdrawedCash;

    /**
     * 提现中金额
     */
    private BigDecimal withdrawingCash;

    /**
     * 总推广金
     */
    private BigDecimal totalPromotionCash;

    /**
     * 可用推广金
     */
    private BigDecimal ablePromotionCash;

    /**
     * 冻结中推广金
     */
    private BigDecimal freezePromotionCash;

    /**
     * 已消费推广金金额
     */
    private BigDecimal consumePromotionCash;

    /**
     * 变更版本
     */
    private Integer version;

    private Date createTime;

    private Date modifyTime;
}