package com.bxm.localnews.merchant.entity;

import java.io.Serializable;
import java.util.Date;

/**
 * t_merchant_action_record
 *
 * @author
 */
public class MerchantActionRecordEntity implements Serializable {
    /**
     * 主键
     */
    private Long id;

    /**
     * 行为动作类型，0：分享、1：访问、2：点击、3：下单
     */
    private Byte actionType;

    /**
     * 所属商户
     */
    private Long merchantId;

    /**
     * 该记录所属用户（如果员工自身则为员工ID）
     */
    private Long belonger;

    /**
     * 执行操作的人，如果是员工，则与所属人一致
     */
    private Long operator;

    /**
     * 最终产生行为动作的用户（浏览、成单等的人）,可能是token
     */
    private String actor;

    /**
     * 记录所属用户昵称
     */
    private String belongerNickName;

    /**
     * 记录所属用户头像
     */
    private String belongerHeadImg;

    /**
     * 行为动作对应的业务ID，如帖子ID，订单ID等
     */
    private Long bizId;

    /**
     * 业务主体类型（描述bizId是什么，帖子、新闻等）
     */
    private String bizType;

    /**
     * 业务主体的标题，用于显示
     */
    private String bizTitle;

    /**
     * 行为用户昵称
     */
    private String actorNickName;

    /**
     * 行为用户头像
     */
    private String actorHeadImg;

    /**
     * 创建时间
     */
    private Date createTime;

    /**
     * 链路id
     */
    private String traceId;

    private static final long serialVersionUID = 1L;

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Byte getActionType() {
        return actionType;
    }

    public void setActionType(Byte actionType) {
        this.actionType = actionType;
    }

    public Long getMerchantId() {
        return merchantId;
    }

    public void setMerchantId(Long merchantId) {
        this.merchantId = merchantId;
    }

    public Long getBelonger() {
        return belonger;
    }

    public void setBelonger(Long belonger) {
        this.belonger = belonger;
    }

    public Long getOperator() {
        return operator;
    }

    public void setOperator(Long operator) {
        this.operator = operator;
    }

    public String getActor() {
        return actor;
    }

    public void setActor(String actor) {
        this.actor = actor;
    }

    public String getBelongerNickName() {
        return belongerNickName;
    }

    public void setBelongerNickName(String belongerNickName) {
        this.belongerNickName = belongerNickName;
    }

    public String getBelongerHeadImg() {
        return belongerHeadImg;
    }

    public void setBelongerHeadImg(String belongerHeadImg) {
        this.belongerHeadImg = belongerHeadImg;
    }

    public Long getBizId() {
        return bizId;
    }

    public void setBizId(Long bizId) {
        this.bizId = bizId;
    }

    public String getBizType() {
        return bizType;
    }

    public void setBizType(String bizType) {
        this.bizType = bizType;
    }

    public String getBizTitle() {
        return bizTitle;
    }

    public void setBizTitle(String bizTitle) {
        this.bizTitle = bizTitle;
    }

    public String getActorNickName() {
        return actorNickName;
    }

    public void setActorNickName(String actorNickName) {
        this.actorNickName = actorNickName;
    }

    public String getActorHeadImg() {
        return actorHeadImg;
    }

    public void setActorHeadImg(String actorHeadImg) {
        this.actorHeadImg = actorHeadImg;
    }

    public Date getCreateTime() {
        return createTime;
    }

    public void setCreateTime(Date createTime) {
        this.createTime = createTime;
    }

    public String getTraceId() {
        return traceId;
    }

    public void setTraceId(String traceId) {
        this.traceId = traceId;
    }
}