package com.bxm.localnews.merchant.entity;

import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;

/**
 * b_merchant_withdraw_flow
 * @author
 */
@Data
public class MerchantWithdrawFlow implements Serializable {
    private Long id;

    /**
     * 提现订单号
     */
    private String orderNo;

    private Long merchantId;

    /**
     * 提现渠道
     */
    private Long payChannel;

    /**
     * 提现的账号实际姓名
     */
    private String realName;

    /**
     * 提现账号
     */
    private String payAccount;

    /**
     * 奖励
     */
    private BigDecimal amount;

    /**
     * 提现手续费
     */
    private BigDecimal fee;

    /**
     * 提现状态 1-待审核 2-支付中 3-支付成功 4-支付失败 5-延迟审核
     */
    private Byte state;

    /**
     * 客户端提现ip
     */
    private String clientIp;

    /**
     * 设备号
     */
    private String equipment;

    /**
     * 微信付款单号
     */
    private String paymentNo;

    /**
     * 提现成功时间
     */
    private String paymentTime;

    private String remark;

    private Date createTime;

    private Date updateTime;

    private static final long serialVersionUID = 1L;
}