package com.bxm.localnews.merchant.entity.coupon;

import lombok.Data;
import org.hibernate.validator.constraints.Length;
import org.hibernate.validator.constraints.Range;

import javax.validation.constraints.Future;
import javax.validation.constraints.NotNull;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;

/**
 * @author 优惠卷基础信息
 */
@Data
public class MerchantCouponInfoEntity implements Serializable {
    /**
     * 主键
     */
    private Long id;

    /**
     * 商家ID
     */
    @NotNull(message = "优惠券必须有所属商户")
    private Long merchantId;

    /**
     * 优惠卷的优惠金额
     */
    @Range(min = 1, max = 99999, message = "劵面额超出限制")
    private BigDecimal discount;

    /**
     * 消费总额
     */
    @Range(min = 1, max = 99999, message = "使用条件金额超出限制")
    private BigDecimal totalAmount;

    /**
     * 允许领取时间
     */
    private Date receiveStartTime;

    /**
     * 允许领取的截止时间
     */
    private Date receiveEndTime;

    /**
     * 可用的起始时间
     */
    @NotNull(message = "优惠券必须指定起始时间")
    private Date usableStartTime;

    /**
     * 可用的截止时间
     */
    @Future(message = "结束时间必须大于当前时间")
    @NotNull(message = "优惠券必须指定截止时间")
    private Date usableEndTime;

    /**
     * 发放数量
     */
    @Range(min = 1, max = 500000, message = "库存数量超出限额")
    private Integer totalQuantity;

    /**
     * 是否有金额门槛
     */
    private Integer conditionAmount;

    /**
     * 是否需要关注（1：有，0：无）
     */
    private Integer conditionFollow;

    /**
     * 劵类型（0：商品优惠卷、1：现金抵扣卷）
     */
    private Integer type;

    /**
     * 创建人ID（用户ID或运营账号ID）,-1表示第三方同步或系统创建
     */
    private Long userId;

    /**
     * 优惠卷来源（0：商户创建、1：运营创建、2：联通同步）
     */
    private Integer source;

    /**
     * 单人可领取的上限
     */
    @Range(min = 1, max = 10, message = "可领取数量超出限额")
    private Integer maxNum;

    /**
     * 使用规则说明
     */
    @Length(max = 60, message = "使用规则不能大于{max}个字符")
    private String ruleRemark;

    /**
     * 分享的文案
     */
    @Length(max = 30, message = "分享文案不能大于{max}个字符")
    private String shareTips;

    /**
     * 创建时间
     */
    private Date createTime;

    /**
     * 变更时间
     */
    private Date modifyTime;

    /**
     * 优惠券状态
     */
    private Integer status;

    /**
     * 优惠券的展现层次
     * 0：所有人不可见
     * 1：商户可见
     */
    private Integer display;

    private static final long serialVersionUID = 1L;
}