package com.bxm.localnews.merchant.param;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.util.Date;

/**
 * @author: zhoujincheng
 * @create: 2020-07-17 14:10
 */
@Data
@ApiModel(description = "后台新增店铺信息入参")
public class ManageMerchantInfoAddParam {

    @ApiModelProperty(value = "店铺名称",required = true)
    @NotBlank(message = "店铺名称不能为空")
    private String merchantName;

    @ApiModelProperty(value = "商户行业分类id",required = true)
    @NotNull(message = "商户行业分类id不能为空")
    private Long categoryId;

    @ApiModelProperty(value = "商家店铺简称",required = true)
    @NotBlank(message = "商家店铺简称不能为空")
    private String shortName;

    @ApiModelProperty(value = "联系人名称",required = true)
    @NotBlank(message = "联系人名称不能为空")
    private String manageName;

    @ApiModelProperty(value = "联系电话",required = true)
    @NotBlank(message = "联系电话不能为空")
    private String mobile;

    @ApiModelProperty(value = "省编码",required = true)
    @NotBlank(message = "省编码不能为空")
    private String provinceCode;

    @ApiModelProperty(value = "市编码",required = true)
    @NotBlank(message = "市编码不能为空")
    private String cityCode;

    @ApiModelProperty(value = "区编码",required = true)
    @NotBlank(message = "区编码不能为空")
    private String countyCode;

    @ApiModelProperty(value = "详细地址信息",required = true)
    @NotBlank(message = "详细地址信息不能为空")
    private String address;

    @ApiModelProperty(value = "开放时间 0: 全天开放 1: 指定时间开放",required = true)
    private Integer openType;

    @ApiModelProperty("营业开始时间 0000 为00:00")
    private String openTime;

    @ApiModelProperty("营业结束时间 0000 为00:00")
    private String closeTime;

    @ApiModelProperty(value = "店铺头图的json数组字符串",required = true)
    @NotBlank(message = "店铺头图不能为空")
    private String headPics;

    @ApiModelProperty("logo图片地址")
    private String logo;

    @ApiModelProperty("相册图片地址的json数组集合")
    private String album;

    @ApiModelProperty("商户一句话描述")
    private String des;

    @ApiModelProperty("商家绑定的用户id")
    private Long userId;

    @ApiModelProperty("店铺详情描述")
    private String detailContent;
}
