package com.bxm.localnews.merchant.param;

import com.bxm.localnews.merchants.param.MerchantInfoParam;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;


@EqualsAndHashCode(callSuper = true)
@Data
@ApiModel(description = "后台审核店铺信息入参")
public class ManageMerchantInfoParam extends MerchantInfoParam {

    @ApiModelProperty(value = "网关获取当前用户")
    private Long currentUserId;

    @ApiModelProperty(value = "当前用户", required = true)
    private Long auditUserId;

    @ApiModelProperty(value = "店铺名称", required = true)
    private String merchantName;

    @ApiModelProperty(value = "商户行业分类id", required = true)
    private Long categoryId;

    @ApiModelProperty(value = "详细地址信息", required = true)
    private String address;

    @ApiModelProperty(value = "店铺头图的json数组字符串", required = true)
    private String headPics;

    @ApiModelProperty("logo图片地址")
    private String logo;

    @ApiModelProperty("商户一句话描述")
    private String des;

    @ApiModelProperty("商家绑定的用户id")
    private Long userId;

    @ApiModelProperty("店铺可用状态 0未审核1审核上架2审核下架")
    private Integer isShelf;

    @ApiModelProperty("下架原因")
    private String removalReason;

}
