/*
 * Copyright 2017 bianxianmao.com All right reserved. This software is the confidential and proprietary information of
 * bianxianmao.com ("Confidential Information"). You shall not disclose such Confidential Information and shall use it
 * only in accordance with the terms of the license agreement you entered into with bianxianmao.com.
 */
package com.bxm.localnews.merchant.param;

import com.bxm.localnews.common.vo.BasicParam;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.math.BigDecimal;

/**
 * @author jieliGG
 * @date 2020/8/20 22:58
 * 商家同意/拒绝退款
 **/
@Data
public class MerchantWithdrawParam extends BasicParam {

    @ApiModelProperty("提现金额 : 元")
    @NotNull(message = "金额不能为空")
    private BigDecimal withdrawMoney;

    @ApiModelProperty("提现商户id")
    @NotNull(message = "提现商户不能为空")
    private Long merchantId;

    @ApiModelProperty("提现手机验证码")
    @NotBlank(message = "验证码不能为空")
    private String code;

    /**
     * 客户端提现ip
     */
    @ApiModelProperty(value = "客户端提现ip", hidden = true)
    private String clientIp;

    /**
     * 提现渠道
     * 1: 微信提现
     * 2: 支付宝提现
     */
    @ApiModelProperty(value = "提现渠道 暂时不需要传入 默认支付宝", hidden = true)
    private Byte withdrawChannel;
}
