package com.bxm.localnews.merchant.param.activity;

import com.bxm.localnews.common.vo.BasicParam;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

/**
 * @author pf.w
 * @date 2020/7/30 18:36
 **/
@Data
@ApiModel(description = "活动出券参数实体")
public class ActivityAdvertParam extends BasicParam {

    @ApiModelProperty(value = "分享者ID", required = true)
    private Long shareUserId;

    @ApiModelProperty(value = "执行人id  userId 或者token", required = true)
    private String actorUserId;

    @ApiModelProperty(value = "内容id 如：新闻 | 帖子 | 等", required = true)
    private Long contentId;

    @ApiModelProperty(value = "类型 新闻 ：NEWS | 帖子 ：FORUM  等", required = true)
    private String contentType;

    @ApiModelProperty(value = "地区编码 扩展字段  3.5.0没有 ", required = false)
    private String areaCode;
}
