package com.bxm.localnews.merchant.param.activity;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotBlank;

/**
 * @author: pf.w
 * @date: 2020/7/30 17:36
 */
@ApiModel(description = "联通大王卡采集信息参数")
@Data
public class UnicomParam extends ActivityInfoBean {

    @ApiModelProperty(value = "姓名", required = true)
    @NotBlank(message = "姓名不能为空")
    private String name;

    @ApiModelProperty(value = "有效证件号码", required = true)
    @NotBlank(message = "有效证件不能为空")
    private String idCard;

    @ApiModelProperty(value = "联系电话", required = true)
    @NotBlank(message = "联系电话不能为空")
    private String phone;

    @ApiModelProperty(value = "省", required = true)
    @NotBlank(message = "省份不能为空")
    private String province;

    @ApiModelProperty("市")
    @NotBlank(message = "市级不能为空")
    private String city;

    @ApiModelProperty("区")
    @NotBlank(message = "区级不能为空")
    private String area;

    @ApiModelProperty("详细地址")
    @NotBlank(message = "详细地址不能为空")
    private String address;

    @ApiModelProperty("选中的联通号码")
    private String selectedPhoneNumb;

    @ApiModelProperty("渠道")
    @NotBlank(message = "渠道不能为空")
    private String channel;

    @ApiModelProperty("短信验证码")
    @NotBlank(message = "短信验证码不能为空")
    private String smsCode;

    @ApiModelProperty("号码归属地 省")
    @NotBlank(message = "号码归属地省份不能为空")
    private String ownerProvince;

    @ApiModelProperty("号码归属地 市")
    @NotBlank(message = "号码归属地市区不能为空")
    private String ownerCity;
}
