package com.bxm.localnews.merchant.param.coupon;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * @author liujia
 * @date 2020-09-21 20:27
 **/
@EqualsAndHashCode(callSuper = true)
@ApiModel(description = "商户核销优惠券")
@Data
public class MerchantCouponCheckParam extends BaseMerchantCouponParam {

    @ApiModelProperty("优惠券ID")
    private Long couponId;

    @ApiModelProperty(value = "用户优惠券ID，数据来自于11-13-05接口返回", required = true)
    private Long userCouponId;
}
