package com.bxm.localnews.merchant.param.coupon;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.util.List;

/**
 * @author liujia
 * @date 2020-09-18 16:34
 **/
@EqualsAndHashCode(callSuper = true)
@Data
@ApiModel(description = "优惠券状态分页查询参数")
public class MerchantCouponStatusPageParam extends BaseMerchantCouponParam {

    @ApiModelProperty(value = "分页查询参数，当前是第几页,min[1]")
    private Integer pageNum = 1;

    @ApiModelProperty(value = "分页查询参数，每页显示数量,默认为10,rang[1,200]")
    private Integer pageSize = 10;

    @ApiModelProperty(value = "优惠券分类状态,1:可领取状态，2：未开始，3：已领完，4：已过期，5：已停用", required = true)
    private Integer status;

    @ApiModelProperty(value = "优惠券的子类状态（实际状态）", hidden = true)
    private List<Integer> subStatus;
}
